/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package chapter9.timezones;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Meeting {
    //A meeting is an array of people across the world (customers and employees) who want to get together.
    Person host;
    Person[] attendees;
    ZonedDateTime meetingDate;

    public Meeting(Person host, LocalDateTime meetingDate) {
        this.host=host;
        this.meetingDate = meetingDate.atZone(host.timezone);
    }
    
    public void displayMeetingDetails(){
        System.out.println("The host "+host.getFullName()+" welcomes you to the meeting.");
        System.out.println("This meeting is on "+meetingDate.toLocalDate()+" at "+meetingDate.toLocalTime());
        System.out.println("For your convenience we have converted the time to your timezone: ");
        for (Person attendee: attendees){
            System.out.println("Name: "+attendee.getFullName());
            ZonedDateTime adjustedTime=meetingDate.withZoneSameInstant(attendee.timezone);
            System.out.println("Time of meeting ("+attendee.timezone+"): "+adjustedTime.toLocalTime());
        }
    }
    
    public void displayMeetingDate(){
        //Various formats
        //ISO standard formats
        DateTimeFormatter myFormatISO = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        DateTimeFormatter myForamtISO2 = DateTimeFormatter.ISO_OFFSET_DATE;
        //Predifined Java formats
        DateTimeFormatter myFormatJAVA = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
        //Custom formats
        DateTimeFormatter myFormatCustom = DateTimeFormatter.ofPattern("EEEE, MMMM, YYYY dd, G, hh:mm A VV");
        //Print out a formatted version of the MeetingDate()
        System.out.println("Meeting Date: "+meetingDate.format(myFormatCustom));
    }
    
}
